<?xml version="1.0" encoding="UTF-8"?><schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <xsl:function xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="u:slack" as="xs:boolean">
    <xsl:param name="exp" as="xs:decimal"/>
    <xsl:param name="val" as="xs:decimal"/>
    <xsl:param name="slack" as="xs:decimal"/>
    <xsl:value-of select="xs:decimal($exp + $slack) &gt;= $val and xs:decimal($exp - $slack) &lt;= $val"/>
  </xsl:function>
  <ns prefix="ext" uri="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2"/>
  <ns prefix="cbc" uri="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2"/>
  <ns prefix="cac" uri="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2"/>
  <ns prefix="qdt" uri="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDataTypes-2"/>
  <ns prefix="udt" uri="urn:oasis:names:specification:ubl:schema:xsd:UnqualifiedDataTypes-2"/>
  <ns prefix="cn" uri="urn:oasis:names:specification:ubl:schema:xsd:CreditNote-2"/>
  <ns prefix="ubl" uri="urn:oasis:names:specification:ubl:schema:xsd:Invoice-2"/>
  <ns prefix="u" uri="utils"/>
  <ns prefix="xs" uri="http://www.w3.org/2001/XMLSchema"/>
  <phase id="PINTmodelaligned_phase">
    <active pattern="UBL-modelaligned"/>
  </phase>
  <phase id="codelistaligned_phase">
    <active pattern="Codesmodelaligned"/>
  </phase>
  <pattern id="UBL-modelaligned">
    <rule context="/ubl:Invoice | /cn:CreditNote">
      <assert id="aligned-ibrp-001-my" flag="fatal" test="starts-with(normalize-space(cbc:CustomizationID/text()), 'urn:peppol:pint:billing-1@my-1')">[aligned-ibrp-001-my]-Specification identifier (ibt-024) MUST start with the value 'urn:peppol:pint:billing-1@my-1'.</assert>
      <assert id="aligned-ibrp-002" flag="fatal" test="/*/cbc:ProfileID and matches(normalize-space(/*/cbc:ProfileID), 'urn:peppol:bis:billing')">[aligned-ibrp-002]-Business process (ibt-023) MUST be in the format 'urn:peppol:bis:billing'.</assert>
      <assert id="ibr-02-my" flag="fatal" test="exists(cac:AccountingSupplierParty/cac:Party/cac:PartyLegalEntity/cbc:CompanyID)">[ibr-02-my]-An Invoice shall have the Supplier’s BRN Number  (ibt-030).</assert>
      <assert id="ibr-03-my" flag="fatal" test="exists(cac:AccountingCustomerParty/cac:Party/cac:PartyLegalEntity/cbc:CompanyID)">[ibr-03-my]-An Invoice shall have the Buyer's BRN Number  (ibt-047).</assert>
      <assert id="ibr-04-my" flag="fatal" test="exists(cac:AccountingSupplierParty/cac:Party/cac:PartyTaxScheme[cac:TaxScheme/cbc:ID != 'VAT']/cbc:CompanyID) or exists(cac:AccountingSupplierParty/cac:Party/cac:PartyIdentification/cbc:ID[not(@schemeID)])">[ibr-04-my]-An Invoice shall have the Supplier’s TIN (ibt-032).</assert>
    </rule>
    <rule context="cac:TaxSubtotal">
      <assert id="aligned-ibrp-046" flag="fatal" test="exists(cbc:TaxAmount)">[aligned-ibrp-046]-Each tax breakdown (ibg-23) MUST have a tax category tax amount (ibt-117).</assert>
    
      <assert id="aligned-ibrp-047" flag="fatal" test="exists(cac:TaxCategory[cac:TaxScheme/normalize-space(upper-case(cbc:ID))='VAT']/cbc:ID) or exists(cac:TaxCategory[cac:TaxScheme/normalize-space(upper-case(cbc:ID))='AAL'][normalize-space(cbc:ID)='TTX'])">[aligned-ibrp-047]-Each tax breakdown (ibg-23) MUST be defined through a tax category code (ibt-118). VAT subtotals need a code; AAL subtotals must use code 'TTX'.</assert>
     
      <assert id="aligned-ibrp-048" flag="fatal" test="(exists(cac:TaxCategory[cac:TaxScheme/normalize-space(upper-case(cbc:ID))='VAT' and (cbc:Percent or normalize-space(cbc:ID)='O')])) or (exists(cac:TaxCategory[cac:TaxScheme/normalize-space(upper-case(cbc:ID))='AAL' and normalize-space(cbc:ID)='TTX' and not(cbc:Percent)]))">[aligned-ibrp-048]-VAT subtotals MUST have a tax rate (ibt-119) except when ID='O'. AAL/TTX subtotals MUST NOT contain a tax rate.</assert>
    </rule>
    
    
    <rule context="/*/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory[normalize-space(cbc:ID) = 'SA'][cac:TaxScheme/normalize-space(upper-case(cbc:ID))='VAT']">
      <assert id="aligned-ibrp-sa-08" flag="fatal" test="every $rate in xs:decimal((cbc:Percent, 0)[1]) satisfies (((exists(//cac:InvoiceLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID) = 'SA'][cac:Item/cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]) or exists(//cac:AllowanceCharge[cac:TaxCategory/normalize-space(cbc:ID)='SA'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate])) and (u:slack(../xs:decimal(cbc:TaxableAmount), sum(../../../cac:InvoiceLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID)='SA'][cac:Item/ cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]/xs:decimal(cbc:LineExtensionAmount)) + sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=true()][cac:TaxCategory/normalize-space(cbc:ID)='SA'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)) - sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=false()][cac:TaxCategory/normalize-space(cbc:ID)='SA'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)),0.02))) or ((exists(//cac:CreditNoteLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID) = 'SA'][cac:Item/cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]) or exists(//cac:AllowanceCharge[cac:TaxCategory/normalize-space(cbc:ID)='SA'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate])) and (u:slack(../xs:decimal(cbc:TaxableAmount), sum(../../../cac:CreditNoteLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID)='SA'][cac:Item/cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]/xs:decimal(cbc:LineExtensionAmount)) + sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=true()][cac:TaxCategory/normalize-space(cbc:ID)='SA'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)) - sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=false()][cac:TaxCategory/normalize-space(cbc:ID)='SA'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)),0.02))))">[aligned-ibrp-sa-08]-For each different value of tax category rate (ibt-119) where the tax category code (ibt-118) is "SA", the tax category taxable amount (ibt-116) in a tax breakdown (ibg-23) MUST equal the sum of Invoice line net amounts (ibt-131) plus the sum of document level charge amounts (ibt-99) minus the sum of document level allowance amounts (ibt-92) where the tax category code (ibt-151, ibt-102, ibt-95) is "SA" and the tax rate (ibt-152, ibt-103, ibt-96) equals the tax category rate (ibt-119).</assert>
      <assert id="aligned-ibrp-sa-09" flag="fatal" test="u:slack(abs(xs:decimal(../cbc:TaxAmount)) , round((abs(xs:decimal(../cbc:TaxableAmount)) * (xs:decimal((cbc:Percent, 0)[1]) div 100)) * 10 * 10) div 100 ,0.02 )">[aligned-ibrp-sa-09]-The tax category tax amount (ibt-117) in a tax breakdown (ibg-23) where tax category code (ibt-118) is "SA" MUST equal the tax category taxable amount (ibt-116) multiplied by the tax category rate (ibt-119).</assert>
      <assert id="aligned-ibrp-sa-10" flag="fatal" test="not(cbc:TaxExemptionReason) and not(cbc:TaxExemptionReasonCode)">[aligned-ibrp-sa-10]-A tax breakdown (ibg-23) with tax Category code (ibt-118) "SA" MUST not have a tax exemption reason code (ibt-121) or tax exemption reason text (ibt-120).</assert>
    </rule>
    
    <rule context="/*/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory[normalize-space(cbc:ID) = 'SE'][cac:TaxScheme/normalize-space(upper-case(cbc:ID))='VAT']">
      <assert id="aligned-ibrp-se-08" flag="fatal" test="every $rate in xs:decimal((cbc:Percent, 0)[1]) satisfies (((exists(//cac:InvoiceLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID) = 'SE'][cac:Item/cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]) or exists(//cac:AllowanceCharge[cac:TaxCategory/normalize-space(cbc:ID)='SE'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate])) and (u:slack(../xs:decimal(cbc:TaxableAmount), sum(../../../cac:InvoiceLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID)='SE'][cac:Item/ cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]/xs:decimal(cbc:LineExtensionAmount)) + sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=true()][cac:TaxCategory/normalize-space(cbc:ID)='SE'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)) - sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=false()][cac:TaxCategory/normalize-space(cbc:ID)='SE'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)),0.02))) or ((exists(//cac:CreditNoteLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID) = 'SE'][cac:Item/cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]) or exists(//cac:AllowanceCharge[cac:TaxCategory/normalize-space(cbc:ID)='SE'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate])) and (u:slack(../xs:decimal(cbc:TaxableAmount), sum(../../../cac:CreditNoteLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID)='SE'][cac:Item/cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]/xs:decimal(cbc:LineExtensionAmount)) + sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=true()][cac:TaxCategory/normalize-space(cbc:ID)='SE'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)) - sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=false()][cac:TaxCategory/normalize-space(cbc:ID)='SE'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)),0.02))))">[aligned-ibrp-se-08]-For each different value of tax category rate (ibt-119) where the tax category code (ibt-118) is "SE", the tax category taxable amount (ibt-116) in a tax breakdown (ibg-23) MUST equal the sum of Invoice line net amounts (ibt-131) plus the sum of document level charge amounts (ibt-99) minus the sum of document level allowance amounts (ibt-92) where the tax category code (ibt-151, ibt-102, ibt-95) is "SE" and the tax rate (ibt-152, ibt-103, ibt-96) equals the tax category rate (ibt-119).</assert>
      <assert id="aligned-ibrp-se-09" flag="fatal" test="u:slack(abs(xs:decimal(../cbc:TaxAmount)) , round((abs(xs:decimal(../cbc:TaxableAmount)) * (xs:decimal((cbc:Percent, 0)[1]) div 100)) * 10 * 10) div 100 ,0.02 )">[aligned-ibrp-se-09]-The tax category tax amount (ibt-117) in a tax breakdown (ibg-23) where tax category code (ibt-118) is "SE" MUST equal the tax category taxable amount (ibt-116) multiplied by the tax category rate (ibt-119).</assert>
      <assert id="aligned-ibrp-se-10" flag="fatal" test="not(cbc:TaxExemptionReason) and not(cbc:TaxExemptionReasonCode)">[aligned-ibrp-se-10]-A tax breakdown (ibg-23) with tax Category code (ibt-118) "SE" MUST not have a tax exemption reason code (ibt-121) or tax exemption reason text (ibt-120).</assert>
    </rule>
    
    <rule context="/*/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory[normalize-space(cbc:ID) = 'HVG'][cac:TaxScheme/normalize-space(upper-case(cbc:ID))='VAT']">
      <assert id="aligned-ibrp-hvg-08" flag="fatal" test="every $rate in xs:decimal((cbc:Percent, 0)[1]) satisfies (((exists(//cac:InvoiceLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID) = 'HVG'][cac:Item/cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]) or exists(//cac:AllowanceCharge[cac:TaxCategory/normalize-space(cbc:ID)='HVG'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate])) and (u:slack(../xs:decimal(cbc:TaxableAmount), sum(../../../cac:InvoiceLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID)='HVG'][cac:Item/ cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]/xs:decimal(cbc:LineExtensionAmount)) + sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=true()][cac:TaxCategory/normalize-space(cbc:ID)='HVG'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)) - sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=false()][cac:TaxCategory/normalize-space(cbc:ID)='HVG'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)),0.02))) or ((exists(//cac:CreditNoteLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID) = 'HVG'][cac:Item/cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]) or exists(//cac:AllowanceCharge[cac:TaxCategory/normalize-space(cbc:ID)='HVG'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate])) and (u:slack(../xs:decimal(cbc:TaxableAmount), sum(../../../cac:CreditNoteLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID)='HVG'][cac:Item/cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]/xs:decimal(cbc:LineExtensionAmount)) + sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=true()][cac:TaxCategory/normalize-space(cbc:ID)='HVG'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)) - sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=false()][cac:TaxCategory/normalize-space(cbc:ID)='HVG'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)),0.02))))">[aligned-ibrp-hvg-08]-For each different value of tax category rate (ibt-119) where the tax category code (ibt-118) is "HVG", the tax category taxable amount (ibt-116) in a tax breakdown (ibg-23) MUST equal the sum of Invoice line net amounts (ibt-131) plus the sum of document level charge amounts (ibt-99) minus the sum of document level allowance amounts (ibt-92) where the tax category code (ibt-151, ibt-102, ibt-95) is "HVG" and the tax rate (ibt-152, ibt-103, ibt-96) equals the tax category rate (ibt-119).</assert>
      <assert id="aligned-ibrp-hvg-09" flag="fatal" test="u:slack(abs(xs:decimal(../cbc:TaxAmount)) , round((abs(xs:decimal(../cbc:TaxableAmount)) * (xs:decimal((cbc:Percent, 0)[1]) div 100)) * 10 * 10) div 100 ,0.02 )">[aligned-ibrp-hvg-09]-The tax category tax amount (ibt-117) in a tax breakdown (ibg-23) where tax category code (ibt-118) is "HVG" MUST equal the tax category taxable amount (ibt-116) multiplied by the tax category rate (ibt-119).</assert>
      <assert id="aligned-ibrp-hvg-10" flag="fatal" test="not(cbc:TaxExemptionReason) and not(cbc:TaxExemptionReasonCode)">[aligned-ibrp-hvg-10]-A tax breakdown (ibg-23) with tax Category code (ibt-118) "HVG" MUST not have a tax exemption reason code (ibt-121) or tax exemption reason text (ibt-120).</assert>
    </rule>
    
    <rule context="/*/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory[normalize-space(cbc:ID) = 'LVG'][cac:TaxScheme/normalize-space(upper-case(cbc:ID))='VAT']">
      <assert id="aligned-ibrp-lvg-08" flag="fatal" test="every $rate in xs:decimal((cbc:Percent, 0)[1]) satisfies (((exists(//cac:InvoiceLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID) = 'LVG'][cac:Item/cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]) or exists(//cac:AllowanceCharge[cac:TaxCategory/normalize-space(cbc:ID)='LVG'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate])) and (u:slack(../xs:decimal(cbc:TaxableAmount), sum(../../../cac:InvoiceLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID)='LVG'][cac:Item/ cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]/xs:decimal(cbc:LineExtensionAmount)) + sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=true()][cac:TaxCategory/normalize-space(cbc:ID)='LVG'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)) - sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=false()][cac:TaxCategory/normalize-space(cbc:ID)='LVG'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)),0.02))) or ((exists(//cac:CreditNoteLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID) = 'LVG'][cac:Item/cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]) or exists(//cac:AllowanceCharge[cac:TaxCategory/normalize-space(cbc:ID)='LVG'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate])) and (u:slack(../xs:decimal(cbc:TaxableAmount), sum(../../../cac:CreditNoteLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID)='LVG'][cac:Item/cac:ClassifiedTaxCategory/xs:decimal((cbc:Percent, 0)[1]) =$rate]/xs:decimal(cbc:LineExtensionAmount)) + sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=true()][cac:TaxCategory/normalize-space(cbc:ID)='LVG'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)) - sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=false()][cac:TaxCategory/normalize-space(cbc:ID)='LVG'][cac:TaxCategory/xs:decimal((cbc:Percent, 0)[1]) = $rate]/xs:decimal(cbc:Amount)),0.02))))">[aligned-ibrp-lvg-08]-For each different value of tax category rate (ibt-119) where the tax category code (ibt-118) is "LVG", the tax category taxable amount (ibt-116) in a tax breakdown (ibg-23) MUST equal the sum of Invoice line net amounts (ibt-131) plus the sum of document level charge amounts (ibt-99) minus the sum of document level allowance amounts (ibt-92) where the tax category code (ibt-151, ibt-102, ibt-95) is "LVG" and the tax rate (ibt-152, ibt-103, ibt-96) equals the tax category rate (ibt-119).</assert>
      <assert id="aligned-ibrp-lvg-09" flag="fatal" test="u:slack(abs(xs:decimal(../cbc:TaxAmount)) , round((abs(xs:decimal(../cbc:TaxableAmount)) * (xs:decimal((cbc:Percent, 0)[1]) div 100)) * 10 * 10) div 100 ,0.02 )">[aligned-ibrp-lvg-09]-The tax category tax amount (ibt-117) in a tax breakdown (ibg-23) where tax category code (ibt-118) is "LVG" MUST equal the tax category taxable amount (ibt-116) multiplied by the tax category rate (ibt-119).</assert>
      <assert id="aligned-ibrp-lvg-10" flag="fatal" test="not(cbc:TaxExemptionReason) and not(cbc:TaxExemptionReasonCode)">[aligned-ibrp-lvg-10]-A tax breakdown (ibg-23) with tax Category code (ibt-118) "LVG" MUST not have a tax exemption reason code (ibt-121) or tax exemption reason text (ibt-120).</assert>
    </rule>
    
    <rule context="/*/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory[normalize-space(cbc:ID)='TTX'][cac:TaxScheme/normalize-space(upper-case(cbc:ID))='AAL']">
      <assert id="aligned-ibrp-ttx-08" flag="fatal" test="not(cbc:Percent)">[aligned-ibrp-ttx-08] – Tourism Tax (TTX/AAL) MUST NOT include a tax percentage.</assert>
      <assert id="aligned-ibrp-ttx-09" flag="fatal" test="(exists(//cac:InvoiceLine)               and u:slack(                     abs(xs:decimal(../cbc:TaxAmount)),                     sum(../../../cac:InvoiceLine                           [cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID)='TTX']                           /cac:TaxTotal/xs:decimal(cbc:TaxAmount))                     + sum(../../../cac:AllowanceCharge                           [cbc:ChargeIndicator=true()]                           [cac:TaxCategory/normalize-space(cbc:ID)='TTX']                           /xs:decimal(cbc:Amount))                     - sum(../../../cac:AllowanceCharge                           [cbc:ChargeIndicator=false()]                           [cac:TaxCategory/normalize-space(cbc:ID)='TTX']                           /xs:decimal(cbc:Amount)),                     0.02                  )           )           or           (exists(//cac:CreditNoteLine)               and u:slack(                     abs(xs:decimal(../cbc:TaxAmount)),                     sum(../../../cac:CreditNoteLine                           [cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID)='TTX']                           /cac:TaxTotal/xs:decimal(cbc:TaxAmount))                     + sum(../../../cac:AllowanceCharge                           [cbc:ChargeIndicator=true()]                           [cac:TaxCategory/normalize-space(cbc:ID)='TTX']                           /xs:decimal(cbc:Amount))                     - sum(../../../cac:AllowanceCharge                           [cbc:ChargeIndicator=false()]                           [cac:TaxCategory/normalize-space(cbc:ID)='TTX']                           /xs:decimal(cbc:Amount)),                     0.02                  )           )">
    [aligned-ibrp-ttx-09] – Tourism Tax (TTX/AAL) amount MUST equal the sum of line-level TTX tax amounts and TTX amounts on document-level allowances/charges.
</assert>
</rule>
    <rule context="cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory[normalize-space(cbc:ID) = 'E'][cac:TaxScheme/normalize-space(upper-case(cbc:ID))='VAT']">
      <assert id="aligned-ibrp-e-08" flag="fatal" test="(exists(//cac:InvoiceLine) and (xs:decimal(../cbc:TaxableAmount) = (sum(../../../cac:InvoiceLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID)='E']/xs:decimal(cbc:LineExtensionAmount)) + sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=true()][cac:TaxCategory/normalize-space(cbc:ID)='E']/xs:decimal(cbc:Amount)) - sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=false()][cac:TaxCategory/normalize-space(cbc:ID)='E']/xs:decimal(cbc:Amount))))) or (exists(//cac:CreditNoteLine) and (xs:decimal(../cbc:TaxableAmount) = (sum(../../../cac:CreditNoteLine[cac:Item/cac:ClassifiedTaxCategory/normalize-space(cbc:ID)='E']/xs:decimal(cbc:LineExtensionAmount)) + sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=true()][cac:TaxCategory/normalize-space(cbc:ID)='E']/xs:decimal(cbc:Amount)) - sum(../../../cac:AllowanceCharge[cbc:ChargeIndicator=false()][cac:TaxCategory/normalize-space(cbc:ID)='E']/xs:decimal(cbc:Amount)))))">[aligned-ibrp-e-08]-In a tax breakdown (ibg-23) where the tax category code (ibt-118) is "Exempt from tax" the tax category taxable amount (ibt-116) MUST equal the sum of Invoice line net amounts (ibt-131) minus the sum of Document level allowance amounts (ibt-92) plus the sum of Document level charge amounts (ibt-99) where the tax category codes (ibt-151, ibt-95, ibt-102) are "Exempt from tax".</assert>
      <assert id="aligned-ibrp-e-09" flag="fatal" test="xs:decimal(../cbc:TaxAmount) = 0">[aligned-ibrp-e-09]-The tax category tax amount (ibt-117) In a tax breakdown (ibg-23) where the tax category code (ibt-118) equals "Exempt from tax" MUST equal 0 (zero).</assert>
    </rule>
    <rule context="cac:InvoiceLine/cac:Item/cac:ClassifiedTaxCategory[normalize-space(cbc:ID) = 'E'][cac:TaxScheme/normalize-space(upper-case(cbc:ID))='VAT'] | cac:CreditNoteLine/cac:Item/cac:ClassifiedTaxCategory[normalize-space(cbc:ID) = 'E'][cac:TaxScheme/normalize-space(upper-case(cbc:ID))='VAT']">
      <assert id="aligned-ibrp-e-05" flag="fatal" test="(xs:decimal((cbc:Percent, 0)[1]) = 0)">[aligned-ibrp-e-05]-In an Invoice line (ibg-25) where the Invoiced item tax category code (ibt-151) is "Exempt from tax", the Invoiced item tax rate (ibt-152) MUST be 0 (zero). </assert>
    </rule>
    <rule context="/*/cac:TaxTotal/cac:TaxSubtotal/cac:TaxCategory[normalize-space(cbc:ID) = 'O'][cac:TaxScheme/normalize-space(upper-case(cbc:ID))='VAT']">
      <assert id="aligned-ibrp-o-09" flag="fatal" test="xs:decimal(../cbc:TaxAmount) = 0">[aligned-ibrp-o-09]-The tax category tax amount (ibt-117) in a tax breakdown (ibg-23) where the tax category code (ibt-118) is "Not subject to tax" MUST be 0 (zero).</assert>
    </rule>
  </pattern>
  <pattern id="Codesmodelaligned">
    <rule flag="fatal" context="cac:TaxCategory/cbc:ID | cac:ClassifiedTaxCategory/cbc:ID">
      <assert id="aligned-ibrp-cl-01-my" flag="fatal" test="( ( not(contains(normalize-space(.),' ')) and contains( ' SA SE HVG LVG E O TTX ',concat(' ',normalize-space(.),' ') ) ) )">[aligned-ibrp-cl-01-my]-Malaysian invoice tax categories MUST be coded using Malaysian codes.</assert>
    </rule>
    <rule flag="fatal" context="cbc:TaxCurrencyCode">
      <assert id="ibr-cl-05-my" flag="fatal" test="( ( not(contains(normalize-space(.),' ')) and contains( ' MYR ',concat(' ',normalize-space(.),' ') ) ) )">[ibr-cl-05-my]-If Tax accounting currency (ibt-006) is present, it shall be coded using MYR in ISO code list of 4217.</assert>
    </rule>
  </pattern>
</schema>